/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.report;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import cz.insophy.inplan.shop.CapabilityIsland;
import cz.insophy.inplan.shop.ShopConfiguration;
import cz.insophy.inplan.shop.Workplace;
import cz.insophy.inplan.superplan.GeneralizedOrderRequest;
import cz.insophy.inplan.util.EventContainer;
import cz.insophy.inplan.util.Formatter;
import cz.insophy.inplan.util.Triple;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CapacityUsageWrapper {
    private final ShopConfiguration conf;
    private final Map<String, EventContainer> capabilityEvents;
    private final Map<CapabilityIsland, EventContainer> islandEvents;
    private final Map<CapabilityIsland, Set<GeneralizedOrderRequest>> islandGors;
    private final Map<GeneralizedOrderRequest, Set<String>> gorCapability;
    private final Map<CapabilityIsland, List<Triple<GeneralizedOrderRequest, String, Double>>> takenCapacity;

    public CapacityUsageWrapper(ShopConfiguration configuration) {
        this.conf = configuration;
        this.capabilityEvents = new HashMap<String, EventContainer>();
        this.islandEvents = new HashMap<CapabilityIsland, EventContainer>();
        this.islandGors = new HashMap<CapabilityIsland, Set<GeneralizedOrderRequest>>();
        this.gorCapability = new HashMap<GeneralizedOrderRequest, Set<String>>();
        this.takenCapacity = new HashMap<CapabilityIsland, List<Triple<GeneralizedOrderRequest, String, Double>>>();
    }

    public Set<String> getAllCapabilities() {
        HashSet<String> res = Sets.newHashSet();
        for (CapabilityIsland island : this.conf.getIslands()) {
            res.addAll(island.getCapabilities());
        }
        return Collections.unmodifiableSet(res);
    }

    public Set<CapabilityIsland> getIslands() {
        return ImmutableSet.copyOf(this.conf.getIslands());
    }

    public CapabilityIsland getIslandOf(String capability) {
        return this.conf.getIsland(capability);
    }

    public Set<GeneralizedOrderRequest> getIslandGors(CapabilityIsland island) {
        if (!this.islandGors.containsKey(island)) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.islandGors.get(island));
    }

    public Set<String> getGorCapabilities(CapabilityIsland island, GeneralizedOrderRequest gor) {
        if (!this.gorCapability.containsKey(gor)) {
            return Collections.emptySet();
        }
        HashSet result = new HashSet(this.gorCapability.get(gor));
        result.retainAll(island.getCapabilities());
        return Collections.unmodifiableSet(result);
    }

    public long getGorCapacityUsed(CapabilityIsland island, GeneralizedOrderRequest gor) {
        long sum = 0L;
        for (String capability : this.getGorCapabilities(island, gor)) {
            sum += this.getGorTakenCapacityOf(island, gor, capability);
        }
        return sum;
    }

    private void addGorTakenCapacity(CapabilityIsland island, GeneralizedOrderRequest gor, String capability, double capacity) {
        if (!this.takenCapacity.containsKey(island)) {
            this.takenCapacity.put(island, new ArrayList());
        }
        this.takenCapacity.get(island).add(new Triple<GeneralizedOrderRequest, String, Double>(gor, capability, capacity));
    }

    private long getGorTakenCapacityOf(CapabilityIsland island, GeneralizedOrderRequest gor, String capability) {
        if (!this.takenCapacity.containsKey(island)) {
            return 0L;
        }
        long sum = 0L;
        for (Triple<GeneralizedOrderRequest, String, Double> entry : this.takenCapacity.get(island)) {
            if (!entry.getFirst().equals(gor) || !entry.getSecond().equals(capability)) continue;
            sum += Math.round(entry.getThird());
        }
        return sum;
    }

    public EventContainer getIslandEvents(CapabilityIsland island) {
        if (!this.islandEvents.containsKey(island)) {
            this.islandEvents.put(island, new EventContainer(0.0));
        }
        return this.islandEvents.get(island);
    }

    public EventContainer getCapabilityEvents(String capability) {
        if (!this.capabilityEvents.containsKey(capability)) {
            this.capabilityEvents.put(capability, new EventContainer(0.0));
        }
        return this.capabilityEvents.get(capability);
    }

    public void addCapacity(Workplace workplace, String capability, long time, double capacity) {
        if (capacity == 0.0) {
            return;
        }
        this.getCapabilityEvents(capability).put(time, capacity, String.format("+ %s | %s @ %s", Formatter.formatDurationHour((long)capacity), capability, workplace.getName()));
    }

    public void addCapacity(Workplace workplace, CapabilityIsland island, long time, double capacity) {
        if (capacity == 0.0) {
            return;
        }
        this.getIslandEvents(island).put(time, capacity, String.format("+ %s | %s @ %s", Formatter.formatDurationHour((long)capacity), island.getName(), workplace.getName()));
    }

    public void takeCapacity(String capability, long time, double capacity, GeneralizedOrderRequest gor) {
        if (capacity == 0.0) {
            return;
        }
        this.getCapabilityEvents(capability).put(time, -capacity, String.format("- %s | %s", Formatter.formatDurationHour((long)capacity), capability));
        CapabilityIsland island = this.getIslandOf(capability);
        this.getIslandEvents(island).put(time, -capacity, String.format("- %s | %s", Formatter.formatDurationHour((long)capacity), island.getName()));
        if (!this.islandGors.containsKey(island)) {
            this.islandGors.put(island, new HashSet());
        }
        this.islandGors.get(island).add(gor);
        if (!this.gorCapability.containsKey(gor)) {
            this.gorCapability.put(gor, new HashSet());
        }
        this.gorCapability.get(gor).add(capability);
        this.addGorTakenCapacity(island, gor, capability, capacity);
    }
}

